/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWStepElement;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import java.util.Date;
import java.util.GregorianCalendar;

public class VWTrkStepElement {
    VWStepElement m_stepElement = null;
    VWTrkWorkObject m_workObject = null;
    int m_stepId = -1;
    Date m_deadline = null;
    int m_status = 0;
    String m_comment = null;
    String m_response = null;
    String m_queueName = null;

    public VWTrkStepElement(VWTrkWorkObject workObject, VWStepElement stepElement) {
        this.m_workObject = workObject;
        this.m_stepElement = stepElement;
    }

    public VWTrkStepElement(VWTrkWorkObject workObject, int stepId, String queueName, int status, String comment, String response) {
        this.m_workObject = workObject;
        this.m_stepId = stepId;
        this.m_queueName = queueName;
        this.m_comment = comment;
        this.m_response = this.m_response;
        this.m_status = status;
    }

    public Long getStepId() {
        return new Long(this.m_stepId);
    }

    public Date getDateReceived() throws VWException {
        if (this.m_stepElement != null) {
            return this.m_stepElement.getDateReceived();
        }
        if (this.m_workObject != null) {
            return this.m_workObject.getDateReceived();
        }
        return null;
    }

    public Date getDeadline() throws VWException {
        if (this.m_stepElement != null) {
            return this.m_stepElement.getDeadline();
        }
        return this.m_deadline;
    }

    public VWTrkWorkObject fetchWorkObject(boolean lock, boolean overrideLock) throws VWException {
        if (lock) {
            this.m_workObject.doLock(overrideLock);
        }
        return this.m_workObject;
    }

    public int getStatus() throws VWException {
        if (this.m_stepElement != null) {
            GregorianCalendar cal = new GregorianCalendar();
            Date deadline = this.m_stepElement.getDeadline();
            if (deadline.before(cal.getTime())) {
                return 9;
            }
            return 1;
        }
        return this.m_status;
    }

    public String getComment() throws VWException {
        if (this.m_stepElement != null) {
            return this.m_stepElement.getComment();
        }
        return this.m_comment;
    }

    public String getSelectedResponse() throws VWException {
        if (this.m_stepElement != null) {
            return this.m_stepElement.getSelectedResponse();
        }
        return this.m_response;
    }

    public VWParticipant getParticipant() throws VWException {
        if (this.m_stepElement != null) {
            return this.m_stepElement.getParticipantNamePx();
        }
        if (this.m_workObject != null) {
            return this.m_workObject.getParticipant();
        }
        return null;
    }

    public String getQueueName() throws VWException {
        if (this.m_stepElement != null) {
            return this.m_stepElement.getQueueName();
        }
        return this.m_queueName;
    }

    public void setComment(String comment) throws VWException {
        if (this.m_stepElement != null) {
            this.m_stepElement.setComment(comment);
        } else {
            this.m_comment = comment;
        }
    }

    public void setSelectedResponse(String response) throws VWException {
        if (this.m_stepElement != null) {
            this.m_stepElement.setSelectedResponse(response);
        } else {
            this.m_response = response;
        }
    }

    public void doDispatch() throws VWException {
        if (this.m_stepElement != null) {
            this.m_stepElement.doDispatch();
        } else if (this.m_workObject != null) {
            this.m_workObject.doDispatch();
        }
    }

    public void doSave(boolean bUnlock) throws VWException {
        if (this.m_stepElement != null) {
            this.m_stepElement.doSave(bUnlock);
        } else if (this.m_workObject != null) {
            this.m_workObject.doSave(bUnlock);
        }
    }
}

